<?php
namespace VM\ApiBundle\DataFixtures\ORM;

use Doctrine\Common\Persistence\ObjectManager;
use Doctrine\Common\DataFixtures\AbstractFixture;
use Doctrine\Common\DataFixtures\OrderedFixtureInterface;
use Symfony\Component\DependencyInjection\ContainerAwareInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use VM\AdminBundle\Services\SsoCommunication;
use VM\AdminBundle\Services\TokensGenerator;
use VM\ApiBundle\Entity\User;
use VM\ApiBundle\Entity\UserGroups;

class LoadUsersAndGroups extends AbstractFixture implements OrderedFixtureInterface, ContainerAwareInterface
{
    /**
     * @var ContainerInterface
     */
    private $container;

    /**
     * @var \Doctrine\ORM\EntityManager
     */
    private $EntityManager;

    /**
     * @var SsoCommunication
     */
    private $SsoCommunication;

    /**
     * @var TokensGenerator
     */
    private $TokensGenerator;


    protected $users = array(
        array('name' => 'nauczyciel', 'surname' => 'nauczyciel', 'email' => 'nauczyciel@vm.pl',
            'groups' => array(
                array('name' => 'Załoga Miłosza', 'users' => array(
                    array('name' => 'uczen1', 'surname' => 'uczen1', 'email' => 'uczen1@vm.pl')
//                    array('name' => 'uczen2', 'surname' => 'uczen2', 'email' => 'uczen2@vm.pl'),
//                    array('name' => 'uczen3', 'surname' => 'uczen3', 'email' => 'uczen3@vm.pl'),
//                    array('name' => 'uczen4', 'surname' => 'uczen4', 'email' => 'uczen4@vm.pl'),
//                    array('name' => 'uczen5', 'surname' => 'uczen5', 'email' => 'uczen5@vm.pl'),
//                    array('name' => 'uczen6', 'surname' => 'uczen6', 'email' => 'uczen6@vm.pl'),
//                    array('name' => 'uczen7', 'surname' => 'uczen7', 'email' => 'uczen7@vm.pl'),
//                    array('name' => 'uczen8', 'surname' => 'uczen8', 'email' => 'uczen8@vm.pl'),
//                    array('name' => 'uczen9', 'surname' => 'uczen9', 'email' => 'uczen9@vm.pl'),
//                    array('name' => 'uczen10', 'surname' => 'uczen10', 'email' => 'uczen10@vm.pl')
                ))
//            ,array('name' => 'Grupa Czesia', 'users' => array(
//                    array('name' => 'uczen11', 'surname' => 'uczen11', 'email' => 'uczen11@vm.pl'),
//                    array('name' => 'uczen12', 'surname' => 'uczen12', 'email' => 'uczen12@vm.pl'),
//                    array('name' => 'uczen13', 'surname' => 'uczen13', 'email' => 'uczen13@vm.pl'),
//                    array('name' => 'uczen14', 'surname' => 'uczen14', 'email' => 'uczen14@vm.pl'),
//                    array('name' => 'uczen15', 'surname' => 'uczen15', 'email' => 'uczen15@vm.pl'),
//                    array('name' => 'uczen16', 'surname' => 'uczen16', 'email' => 'uczen16@vm.pl'),
//                    array('name' => 'uczen17', 'surname' => 'uczen17', 'email' => 'uczen17@vm.pl'),
//                    array('name' => 'uczen18', 'surname' => 'uczen18', 'email' => 'uczen18@vm.pl'),
//                    array('name' => 'uczen19', 'surname' => 'uczen19', 'email' => 'uczen19@vm.pl'),
//                    array('name' => 'uczen20', 'surname' => 'uczen20', 'email' => 'uczen20@vm.pl')
//                ))
            )
        )
        ,array('name' => 'admin', 'surname' => 'vm', 'email' => 'it@vm.pl',
            'groups' => array(
                array('name' => 'Grupa Rafała', 'users' => array(
                    array('name' => 'it1', 'surname' => 'it1', 'email' => 'it1@vm.pl'),
                    array('name' => 'it2', 'surname' => 'it2', 'email' => 'it2@vm.pl'),
                    array('name' => 'it3', 'surname' => 'it3', 'email' => 'it3@vm.pl'),
                    array('name' => 'it4', 'surname' => 'it4', 'email' => 'it4@vm.pl'),
                    array('name' => 'it5', 'surname' => 'it5', 'email' => 'it5@vm.pl'),
                    array('name' => 'it6', 'surname' => 'it6', 'email' => 'it6@vm.pl'),
                    array('name' => 'it7', 'surname' => 'it7', 'email' => 'it7@vm.pl'),
                    array('name' => 'it8', 'surname' => 'it8', 'email' => 'it8@vm.pl'),
                    array('name' => 'it9', 'surname' => 'it9', 'email' => 'it9@vm.pl'),
                    array('name' => 'it10', 'surname' => 'it10', 'email' => 'it10@vm.pl')
                ))
            ,array('name' => 'Grupa Adama', 'users' => array(
                    array('name' => 'it11', 'surname' => 'it11', 'email' => 'it11@vm.pl'),
                    array('name' => 'it12', 'surname' => 'it12', 'email' => 'it12@vm.pl'),
                    array('name' => 'it13', 'surname' => 'it13', 'email' => 'it13@vm.pl'),
                    array('name' => 'it14', 'surname' => 'it14', 'email' => 'it14@vm.pl'),
                    array('name' => 'it15', 'surname' => 'it15', 'email' => 'it15@vm.pl'),
                    array('name' => 'it16', 'surname' => 'it16', 'email' => 'it16@vm.pl'),
                    array('name' => 'it17', 'surname' => 'it17', 'email' => 'it17@vm.pl'),
                    array('name' => 'it18', 'surname' => 'it18', 'email' => 'it18@vm.pl'),
                    array('name' => 'it19', 'surname' => 'it19', 'email' => 'it19@vm.pl'),
                    array('name' => 'it20', 'surname' => 'it20', 'email' => 'it20@vm.pl')
                ))
            )
        )
        ,array('name' => 'prezentacja', 'surname' => 'vm', 'email' => 'prezentacja@vm.pl', 'groups' => array())
        ,array('name' => 'Michał', 'surname' => 'Pyrka', 'email' => 'michal.pyrka@vm.pl', 'groups' => array())
        ,array('name' => 'Mariusz', 'surname' => 'Stasiak', 'email' => 'mariusz.stasiak@vm.pl', 'groups' => array())
        ,array('name' => 'Rafał', 'surname' => 'Ignaszewski', 'email' => 'rafal@vm.pl', 'groups' => array())
        ,array('name' => 'Aleksandra', 'surname' => 'Grycz', 'email' => 'aleksandra.grycz@vm.pl', 'groups' => array())
    );


    /**
     * {@inheritDoc}
     */
    public function setContainer(ContainerInterface $container = null)
    {
        $this->container = $container;
        $this->SsoCommunication = $this->container->get('vm_admin.sso.communication');
        $this->TokensGenerator = $this->container->get('vm_admin.tokens.generator');
    }


    public function load(ObjectManager $EntityManager)
    {
        $this->EntityManager = $EntityManager;


        foreach($this->users as $userData)
        {
            $result = $this->SsoCommunication->loginUser($userData['email'], md5($userData['surname']));
            //            try
            //            {
            //            }
            //            catch(\Exception $e)
            //            {
            //                $result = $this->SsoCommunication->registerUser($userData['name'], $userData['surname'], $userData['email']);
            //            }

            $userData['external_id'] = $result['user_id'];

            $Teacher = $this->createUser($userData, array('ROLE_TEACHER'));

            foreach($userData['groups'] as $groupData)
            {
                $UserGroup = new UserGroups();
                $UserGroup->setUser($Teacher);
                $UserGroup->setName($groupData['name']);

                $this->EntityManager->persist($UserGroup);

                foreach($groupData['users'] as $studentData)
                {
                    try
                    {
                        $resultStudent = $this->SsoCommunication->loginUser($studentData['email'], md5($studentData['surname']));
                    }
                    catch (\Exception $exception)
                    {
                        echo 'Email: '.$studentData['email'];
                        throw $exception;
                    }
                    $studentData['external_id'] = $resultStudent['user_id'];
                    $Student = $this->createUser($studentData);

                    $Student->setGroup($UserGroup);

                    $this->TokensGenerator->getNewTokensList($Student, $Student);
                }
            }
        }

        $this->EntityManager->flush();
    }


    /**
     * @param $userData
     * @param array $roles
     * @return User
     */
    public function createUser($userData, $roles = array('ROLE_USER'))
    {

        $User = new User();
        $now = new \DateTime();
        $User->setInternalUser(true);
        $User->setExternalId($userData['external_id']);

        $User->setUsername($userData['email']);
        $User->setEmail($userData['email']);
        $User->setLastLogin($now);
        $User->setRoles($roles);
        $User->setName($userData['name']);
        $User->setSurname($userData['surname']);
        $User->setVisitsCount(0);

        $this->EntityManager->persist($User);

        return $User;
    }

    public function getOrder()
    {
        return 1000;
    }
}